
> 新增cid 对应的区域字段 （方式一）

执行sql 
```sql
create table sys_log_new like sys_log;


 ALTER TABLE `sys_log_new`   
 ADD COLUMN  `province_id` bigint(20) unsigned DEFAULT NULL COMMENT '省编号', 
 ADD COLUMN  `city_id` bigint(20) unsigned DEFAULT NULL COMMENT '市编号', 
 ADD COLUMN  `area_id` bigint(20) unsigned DEFAULT NULL COMMENT '区域ID', 
 ADD COLUMN  `street_id` bigint(20) unsigned DEFAULT NULL COMMENT '乡镇街道编号' ;
ALTER TABLE `sys_log_new`    add index inx_update(update_date)  ; 
	
	
INSERT INTO sys_log_new (
	id,
	cid,
	username,
	fullname,
	title,
	remote_ip,
	user_agent,
	request_uri,
	request_method,
	is_valid,
	type,
	params,
	create_by,
	create_date,
	update_by,
	update_date,
	log_source,
	province_id,
	city_id,
	area_id,
	street_id 
)  
SELECT   
	l.id,
	l.cid,
	l.username,
	l.fullname,
	l.title,
	l.remote_ip,
	l.user_agent,
	l.request_uri,
	l.request_method,
	l.is_valid,
	l.type,
	l.params,
	l.create_by,
	l.create_date,
	l.update_by,
	l.update_date,
	l.log_source,
	a.province_id, a.city_id, a.area_id, a.street_id
FROM sys_log l
LEFT JOIN ( 
	select t.cid, t.area_id from ( 
			SELECT
				id cid,
				area_id 
			FROM
				organization o UNION all
			SELECT
				id cid,
				area_id 
			FROM
				db_bigdata_center.company UNION all
			SELECT
				id cid,
				area_id 
			FROM
				third_organization.third_organization
	) t group by t.cid 
) la ON l.cid = la.cid
LEFT JOIN db_bigdata_center.sys_area a ON la.area_id = a.id 
WHERE 
	l.is_valid = 1 
```



> 方式（二） 直接操作原数据表
```sql

 ALTER TABLE `sys_log`   
 ADD COLUMN  `province_id` bigint(20) unsigned DEFAULT NULL COMMENT '省编号', 
 ADD COLUMN  `city_id` bigint(20) unsigned DEFAULT NULL COMMENT '市编号', 
 ADD COLUMN  `area_id` bigint(20) unsigned DEFAULT NULL COMMENT '区域ID', 
 ADD COLUMN  `street_id` bigint(20) unsigned DEFAULT NULL COMMENT '乡镇街道编号' ;

 update  sys_log l left join
     (SELECT id cid,area_id from organization o
     union
     select  id cid,area_id  from  test3_bigdata.company
     union
     select  id cid,area_id  from  third_organization.third_organization
     ) la on l.cid=la.cid
     left join test3_bigdata.sys_area a on la.area_id =a.id
     set  l.province_id = a.province_id ,
         l.city_id = a.city_id ,
         l.area_id = a.area_id ,
         l.street_id = a.street_id 
```